#include "StdAfx.h"
#include "PythonApplication.h"
#include "ProcessScanner.h"
#include "resource.h"

#include <process.h>
#include <Tlhelp32.h>
#include <winbase.h>
#include <string.h>

#ifdef _DEBUG
#include <crtdbg.h>
#endif

#ifdef ENABLE_HWID_BAN_SYSTEM
#include "HWIDManager.h"
#endif

#include "../EterFSLib/FileSystemIncl.hpp"
#include "../eterLib/Util.h"
#include "../CWebBrowser/CWebBrowser.h"
#include "../eterBase/CPostIt.h"

#include "CheckLatestFiles.h"
#ifdef ENABLE_CRASH_RPT
#include <CrashRpt.h>
#endif

#include <tbb/parallel_for.h>

#if defined(CHECK_WEB_URL)
#include "check_url.h"
#endif

#ifdef max
#undef max
#endif

#ifdef min
#undef min
#endif

#include <rapidjson/document.h>
#include <rapidjson/error/en.h>

#ifdef DISTRIBUTE
#include <xorstr.hpp>
#endif

extern "C" {
extern int _fltused;
volatile int _AVOID_FLOATING_POINT_LIBRARY_BUG = _fltused;
__declspec(dllexport) DWORD NvOptimusEnablement = 0x00000001;
__declspec(dllexport) int AmdPowerXpressRequestHighPerformance = 1;
};

#pragma comment(linker, "/NODEFAULTLIB:libci.lib")

#ifdef __USE_CYTHON__
extern "C" {
	void initrootlib();
	void initsystem();
}
#pragma comment( lib, "rootlib.lib" )
#endif

#pragma comment( lib, "version.lib" )
#pragma comment(lib, "cryptopp-static.lib")

#if GrannyProductMinorVersion==4
#pragma comment( lib, "granny2.4.0.10.lib" )
#elif GrannyProductMinorVersion==7
#pragma comment( lib, "granny2.7.0.30.lib" )
#elif GrannyProductMinorVersion==8
#pragma comment( lib, "granny2.8.49.0.lib" )
#elif GrannyProductMinorVersion==9
#pragma comment( lib, "granny2.9.12.0.lib" )
#elif GrannyProductMinorVersion==11
#pragma comment( lib, "granny2.11.8.0.lib" )
#else
#error "unknown granny version"
#endif

#ifdef _DEBUG
#pragma comment( lib, "python27_d.lib" )
#pragma comment( lib, "jpegd.lib" )
#pragma comment( lib, "lz4d.lib")
#pragma comment( lib, "xxhashd.lib")
#else
#pragma comment( lib, "python27.lib" )
#pragma comment( lib, "jpeg.lib" )
#pragma comment( lib, "lz4.lib")
#pragma comment( lib, "xxhash.lib")
#endif
#pragma comment( lib, "imagehlp.lib" )
#pragma comment( lib, "devil.lib" )

#pragma comment( lib, "mss32.lib" )
#pragma comment( lib, "winmm.lib" )
#pragma comment( lib, "imm32.lib" )
#pragma comment( lib, "oldnames.lib" )
#pragma comment( lib, "SpeedTreeRT.lib" )
#pragma comment( lib, "dinput8.lib" )
#pragma comment( lib, "dxguid.lib" )
#pragma comment( lib, "ws2_32.lib" )
#pragma comment( lib, "strmiids.lib" )
#pragma comment( lib, "ddraw.lib" )
#pragma comment( lib, "dmoguids.lib" )
#ifdef __ENABLE_NEW_OFFLINESHOP__
#pragma comment( lib, "shlwapi.lib" )
#pragma comment( lib, "libconfig.lib" )
#pragma comment( lib, "libconfig++.lib" )
#endif

#pragma comment( lib, "libcurl.lib" )

#include <cstdlib>
bool __IS_TEST_SERVER_MODE__=false;

extern bool SetDefaultCodePage(DWORD codePage);


int Setup(LPSTR lpCmdLine); // Internal function forward

static bool PackInitialize(CFile& file, FileSystemManager* file_system)
{
	rapidjson::Document document;
	document.Parse(reinterpret_cast<const char*>(file.GetData()));

	if (document.HasParseError())
	{
		TraceError("%ls parse failed! Error: %s offset: %u", file.GetFileName().c_str(), GetParseError_En(document.GetParseError()), document.GetErrorOffset());
		return false;
	}

	if (!document.HasMember("pack_dir"))
	{
		TraceError("%ls has no member `pack_dir`", file.GetFileName().c_str());
		return false;
	}

	if (!document.HasMember("files"))
	{
		TraceError("%ls has no member `files`", file.GetFileName().c_str());
		return false;
	}

	if (!document["pack_dir"].IsString())
	{
		TraceError("%ls type member `pack_dir` is not string", file.GetFileName().c_str());
		return false;
	}

	if (!document["files"].IsArray())
	{
		TraceError("%ls type member `files` is not array", file.GetFileName().c_str());
		return false;
	}

	const std::string pack_dir = document["pack_dir"].GetString();
	const auto& files = document["files"];

	parallel_for(tbb::blocked_range<int32_t>(0, files.Size()),
		[&](const tbb::blocked_range<int32_t> r)
		{
			for (auto i = r.begin(); i < r.end(); ++i)
			{
				if (!files[i].IsString())
					continue;

				const auto& name = pack_dir + files[i].GetString() + ".pak";
				const auto& key = file_system->GetArchiveKey(name);
				if (!file_system->AddArchive(name, key)) {
					abort();
				}
			}
			return true;
		}
	);
	return true;
}

bool RunMainScript(CPythonLauncher& pyLauncher, const char* lpCmdLine)
{
	initServerStateChecker();
	initpack();
	initdbg();
	initime();
	initgrp();
	initgrpImage();
	initgrpText();
	initwndMgr();
	initudp();
	initapp();
	initsystemSetting();
#ifdef INGAME_WIKI
	initWiki();
#endif
	initchr();
	initchrmgr();
	initPlayer();
	initItem();
	initNonPlayer();
	initTrade();
	initChat();
	initTextTail();
	initnet();
	initMiniMap();
	initProfiler();
	initEvent();
	initeffect();
	initfly();
	initsnd();
	initshop();
	initskill();
	initquest();
	initBackground();
	initMessenger();
	initsafebox();
	initguild();
	initCheat(); //Anti Cheat
	initThreadPack(); // Anti Cheat
#ifdef ENABLE_SWITCHBOT
	initSwitchbot();
#endif

#ifdef __ENABLE_NEW_OFFLINESHOP__
	initofflineshop();
#endif
#ifdef ENABLE_BATTLE_PASS
	initBattlePass();
#endif
    PyObject * builtins = PyImport_ImportModule("__builtin__");

#ifdef _DEBUG
	PyModule_AddIntConstant(builtins, "__DEBUG__", 1);
#else
	PyModule_AddIntConstant(builtins, "__DEBUG__", 0);
#endif

#ifdef __USE_CYTHON__
	PyModule_AddIntConstant(builtins, "__USE_CYTHON__", 1);
#else
	PyModule_AddIntConstant(builtins, "__USE_CYTHON__", 0);
#endif

#ifdef __USE_CYTHON__
	initrootlib();
	initsystem();
	PyErr_Print();
#else
	PyModule_AddStringConstant(builtins, "__COMMAND_LINE__", lpCmdLine);
	const char* filename = "pack/root.pak";
	if (!pyLauncher.RunFile(filename))
	{
		TraceError("Failed to run file %s", filename);
		std::system("PAUSE");
		return false;
	}
#endif

	return true;
}

bool Main(HINSTANCE hInstance, LPSTR lpCmdLine)
{
#if defined(CHECK_WEB_URL)
	if (!URL_CheckWebResponse())
		return false;
#endif

	DWORD dwRandSeed=time(nullptr)+DWORD(GetCurrentProcess());
	srandom(dwRandSeed);
	srand(random());

	SetLogLevel(1);

#ifndef __VTUNE__
	ilInit();
#endif
	if (!Setup(lpCmdLine))
		return false;

#ifdef _DEBUG
	OpenConsoleWindow();
	OpenLogFile(true); // true == uses syserr.txt and log.txt
#else
	OpenLogFile(false); // false == uses syserr.txt only
#endif

	static CLZO				lzo;
	FileSystemManager file_system;

#ifdef ENABLE_HWID_BAN_SYSTEM
	static HWIDMANAGER		hwidManager;
#endif

	CTextFileLoader::SetCacheMode();
	CSoundData::SetPackMode();

	if (!file_system.InitializeFSManager(
#ifdef ENABLE_LAYER2_FILE_ENCRYPTION
		FILE_FLAG_XTEA
#endif
	))
	{
		LogBox("FileSystem Initialization failed");
		return false;
	}

#ifdef DISTRIBUTE
	file_system.AddToDiskBlacklist(xorstr_("py"));
	file_system.AddToDiskBlacklist(xorstr_("pyc"));
#endif

	CFile file;
	const std::string pack_file = "packs.json";
	if (!file_system.OpenFile(pack_file, file))
	{
		TraceError("Failed to open %s", pack_file.c_str());
		file.Close();
		return false;
	}

	if (!PackInitialize(file, &file_system))
	{
		LogBox("Pack Initialization failed.");
		file.Close();
		return false;
	}

	if(LocaleService_LoadGlobal(hInstance))
		SetDefaultCodePage(LocaleService_GetCodePage());

	CPythonApplication * app = new CPythonApplication;

	app->Initialize(hInstance);

	bool ret=false;
	{
		CPythonLauncher pyLauncher;
		if (pyLauncher.Create())
		{
			ret=RunMainScript(pyLauncher, lpCmdLine);
		}

		app->Clear();

		timeEndPeriod(1);
		CPythonLauncher::Clear();
	}

	app->Destroy();
	delete app;

	return ret;
}

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	CreateDirectoryA("logs", nullptr);

#ifdef ENABLE_CRASH_RPT
	crash_rpt::CrashRpt g_crashRpt(
		"9e3f5dec-41e0-4eca-b201-1939b30eb6b6",
		L"Sinner2 Crash Reporter",
		L""
	);
	g_crashRpt.AddFileToReport(L"syserr.txt", nullptr);
	//g_crashRpt.AddFileToReport(L"logs/fs_log.txt", nullptr);
#endif

#ifdef _DEBUG
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_CHECK_CRT_DF | _CRTDBG_LEAK_CHECK_DF );

#endif

	LocaleService_LoadConfig("locale.cfg");
	SetDefaultCodePage(LocaleService_GetCodePage());

	WebBrowser_Startup(hInstance);

	Main(hInstance, lpCmdLine);

	WebBrowser_Cleanup();

	::CoUninitialize();

	return 0;
}


int Setup(LPSTR lpCmdLine)
{
	TIMECAPS tc;
	UINT wTimerRes;

	if (timeGetDevCaps(&tc, sizeof(TIMECAPS)) != TIMERR_NOERROR)
		return 0;

	wTimerRes = MINMAX(tc.wPeriodMin, 1, tc.wPeriodMax);
	timeBeginPeriod(wTimerRes);

	return 1;
}

void killProcessByName(const char *filename)
{
    HANDLE hSnapShot = CreateToolhelp32Snapshot(TH32CS_SNAPALL, NULL);
    PROCESSENTRY32 pEntry;
    pEntry.dwSize = sizeof (pEntry);
    BOOL hRes = Process32First(hSnapShot, &pEntry);
    while (hRes)
    {
        if (strcmp(pEntry.szExeFile, filename) == 0)
        {
            HANDLE hProcess = OpenProcess(PROCESS_TERMINATE, 0,
                                          (DWORD) pEntry.th32ProcessID);
            if (hProcess != NULL)
            {
                TerminateProcess(hProcess, 9);
                CloseHandle(hProcess);
            }
        }
        hRes = Process32Next(hSnapShot, &pEntry);
    }
    CloseHandle(hSnapShot);
}
void initCheat()
{
  HANDLE hProcessSnap;
  HANDLE hProcess;
  PROCESSENTRY32 pe32;
  DWORD dwPriorityClass;
  string cExeFile, sVocable, sConsonant;
  string __VOCABLES = "aAbBeEiIoOuUyY";
  string __Consonants = "bBcCdDfFgGhHjJkKlLmMnNpPqQrRsStTvVwWxXyYzZ";
  //string __VOCABLES[] = {'a', 'A', 'e', 'E', 'i', 'I', 'o', 'O', 'u', 'U'};
  //string __Consontants[] = { 'b', 'B', 'c', 'C', 'd', 'D', 'f', 'F', 'g', 'G', 'h', 'H', 'j', 'J', 'k', 'K'
  //	, 'l', 'L', 'm', 'M', 'n', 'N', 'n', 'N', 'p', 'P', 'q', 'Q', 'r', 'R', 's', 'S', 't', 'T', 'v', 'V', 'w', 'W', 'x', 'X' 
  //	, 'y', 'Y', 'z', 'Z'};
  int iCountFake = 0;

  hProcessSnap = CreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
  if( hProcessSnap == INVALID_HANDLE_VALUE )
  {
    TraceError("CreateToolhelp32Snapshot (of processes)");
  }

  pe32.dwSize = sizeof( PROCESSENTRY32 );

  if( !Process32First( hProcessSnap, &pe32 ) )
  {
    CloseHandle( hProcessSnap );          // clean the snapshot object
  }
  
  do
  {
	if (strcmp(pe32.szExeFile, "cheatengine-x86_64.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	if (strcmp(pe32.szExeFile, "Metin2 Bot.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	if (strcmp(pe32.szExeFile, "HLBotSecure.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(pe32.szExeFile, "cheatengine-x86.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(pe32.szExeFile, "cheatengine-x64.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(pe32.szExeFile, "cheatenginex86_64.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(pe32.szExeFile, "cheatengine.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(pe32.szExeFile, "perfmon.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(pe32.szExeFile, "MacroRecorder.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(pe32.szExeFile, "cmd.exe") == 0)
	{
		killProcessByName(pe32.szExeFile);
		killProcessByName("Zenitar.exe");
	}
    // Retrieve the priority class.
    dwPriorityClass = 0;
    hProcess = OpenProcess( PROCESS_ALL_ACCESS, FALSE, pe32.th32ProcessID );

   if (hProcess != NULL)
    {
      dwPriorityClass = GetPriorityClass( hProcess );
      if( !dwPriorityClass )
        TraceError("GetPriorityClass");
      CloseHandle( hProcess );
    }

    // List the modules and threads associated with this process
    bListProcModules( pe32.th32ProcessID );

  } while( Process32Next( hProcessSnap, &pe32 ) );

  CloseHandle( hProcessSnap );
}

BOOL bListProcModules( DWORD dwPID )
{
  HANDLE hModuleSnap = INVALID_HANDLE_VALUE;
  MODULEENTRY32 me32;

  // Take a snapshot of all modules in the specified process.
  hModuleSnap = CreateToolhelp32Snapshot( TH32CS_SNAPMODULE, dwPID );
  if( hModuleSnap == INVALID_HANDLE_VALUE )
  {
    //TraceError("CreateToolhelp32Snapshot (of modules)");
    return( FALSE );
  }

  // Set the size of the structure before using it.
  me32.dwSize = sizeof( MODULEENTRY32 );

  // Retrieve information about the first module,
  // and exit if unsuccessful
  if( !Module32First( hModuleSnap, &me32 ) )
  {
    CloseHandle( hModuleSnap );           // clean the snapshot object
    return( FALSE );
  }

  // Now walk the module list of the process,
  // and display information about each module
  do
  {
	if (strcmp(me32.szModule, "Python_Loader_2.7.dll") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(me32.szModule, "Injector.exe") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(me32.szModule, "Extreme_Injector_v3.exe") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(me32.szModule, "Extreme Injector v3.exe") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(me32.szModule, "starter.exe") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(me32.szModule, "perfmon.exe") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(me32.szModule, "MacroRecorder.exe") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	else if (strcmp(me32.szModule, "cmd.exe") == 0)
	{
		killProcessByName(me32.szModule);
		killProcessByName("Zenitar.exe");
	}
	//TraceError("MODULE NAME_PORCARACTER:     %s \n",   cModule_name );
    //TraceError("    Executable     = %s \n",     me32.szExePath );
  } while( Module32Next( hModuleSnap, &me32 ) );

  CloseHandle( hModuleSnap );
  return( TRUE );
}

void vAntiCheat()
{
	HANDLE hProcessSnap;
	HANDLE hProcess;
	PROCESSENTRY32 pe32;
	DWORD dwPriorityClass;
	string cExeFile, sVocable, sConsonant;
	string __VOCABLES = "aAbBeEiIoOuU";
	string __Consonants = "bBcCdDfFgGhHjJkKlLmMnNpPqQrRsStTvVwWxXyYzZ";
	//string __VOCABLES[] = {'a', 'A', 'e', 'E', 'i', 'I', 'o', 'O', 'u', 'U'};
	//string __Consontants[] = { 'b', 'B', 'c', 'C', 'd', 'D', 'f', 'F', 'g', 'G', 'h', 'H', 'j', 'J', 'k', 'K'
	//	, 'l', 'L', 'm', 'M', 'n', 'N', 'n', 'N', 'p', 'P', 'q', 'Q', 'r', 'R', 's', 'S', 't', 'T', 'v', 'V', 'w', 'W', 'x', 'X' 
	//	, 'y', 'Y', 'z', 'Z'};
 	int iCountFake = 0;
	// Take a snapshot of all processes in the system.
	hProcessSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
	if (hProcessSnap == INVALID_HANDLE_VALUE)
	{
		TraceError("CreateToolhelp32Snapshot (of processes)");
	}

	// Set the size of the structure before using it.
	pe32.dwSize = sizeof(PROCESSENTRY32);

	// Retrieve information about the first process,
	// and exit if unsuccessful
	if (!Process32First(hProcessSnap, &pe32))
	{
		CloseHandle(hProcessSnap);          // clean the snapshot object
	}

	do
	{
		if (strcmp(pe32.szExeFile, "cheatengine-x86_64.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		if (strcmp(pe32.szExeFile, "Metin2 Bot.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		if (strcmp(pe32.szExeFile, "HLBotSecure.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "cheatengine-x86.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "cheatengine-x64.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "cheatenginex86_64.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "cheatengine.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "Python_Loader_2.7.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "Injector.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "Extreme_Injector_v3.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "Extreme Injector v3.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "Multihack_kamer.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "ProDamage.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "InviDropper.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "PickUp-Bot.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "Spam-Bot.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "m2PythonLoader.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "SendAttackToTarget.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "M2Bob_Dll.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "kagb22.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "sqlite3.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "Danut.dll") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "starter.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "starter.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "lalaker1.app.injector.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "lalaker1.app") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "perfmon.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "MacroRecorder.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		else if (strcmp(pe32.szExeFile, "cmd.exe") == 0)
		{
			killProcessByName(pe32.szExeFile);
			killProcessByName("Zenitar.exe");
		}
		// Retrieve the priority class.
		dwPriorityClass = 0;
		hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pe32.th32ProcessID);

		if (hProcess != NULL)
		{
			dwPriorityClass = GetPriorityClass(hProcess);
			if (!dwPriorityClass)
				TraceError("GetPriorityClass");
			CloseHandle(hProcess);
		}

		// List the modules and threads associated with this process
		bListProcModules(pe32.th32ProcessID);

	} while (Process32Next(hProcessSnap, &pe32));

	CloseHandle(hProcessSnap);
}

void initThreadPack(){
	CreateThread(NULL, NULL, LPTHREAD_START_ROUTINE(vScan_thread), NULL, 0, 0);
}

void vScan_thread(){
	Sleep(2000);
again:
	vAntiCheat();
	Sleep(2000);
	goto again;
}

bool bKillProc(const char *filename)
{
	HANDLE hSnapShot = CreateToolhelp32Snapshot(TH32CS_SNAPALL, NULL);
	PROCESSENTRY32 pEntry;
	pEntry.dwSize = sizeof(pEntry);
	BOOL hRes = Process32First(hSnapShot, &pEntry);
	while (hRes)
	{
		if (strcmp(pEntry.szExeFile, filename) == 0)
		{
			HANDLE hProcess = OpenProcess(PROCESS_TERMINATE, 0, (DWORD)pEntry.th32ProcessID);
			if (hProcess != NULL)
			{
				TerminateProcess(hProcess, 1);
				CloseHandle(hProcess);
				return true;
			}
		}
		hRes = Process32Next(hSnapShot, &pEntry);
	}
	CloseHandle(hSnapShot);
	return false;
}